/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.DecoratorFactory;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.InvalidTagAttributeValueException;
import org.displaytag.exception.ObjectLookupException;
import org.displaytag.export.BaseExportView;
import org.displaytag.export.ExportViewFactory;
import org.displaytag.export.MediaTypeEnum;
import org.displaytag.filter.ResponseOverrideFilter;
import org.displaytag.model.Cell;
import org.displaytag.model.Column;
import org.displaytag.model.ColumnIterator;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.Row;
import org.displaytag.model.RowIterator;
import org.displaytag.model.TableModel;
import org.displaytag.pagination.SmartListHelper;
import org.displaytag.properties.TableProperties;
import org.displaytag.tags.HtmlTableTag;
import org.displaytag.util.Anchor;
import org.displaytag.util.CollectionUtil;
import org.displaytag.util.Href;
import org.displaytag.util.RequestHelper;

public class TableTag
extends HtmlTableTag {
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$tags$TableTag == null ? (class$org$displaytag$tags$TableTag = TableTag.class$("org.displaytag.tags.TableTag")) : class$org$displaytag$tags$TableTag));
    public static final String PAGE_ATTRIBUTE_MEDIA = "mediaType";
    private static boolean commonsLangChecked = false;
    private Iterator tableIterator;
    private int rowNumber = 1;
    private Object list = null;
    private String name;
    private String property;
    private String scope;
    private Hashtable previousRow = null;
    private TableModel tableModel;
    private Row currentRow;
    private Hashtable nextRow = null;
    private int length = 0;
    private String decoratorName;
    private int pagesize = 0;
    private boolean export = false;
    private SmartListHelper listHelper = null;
    private Href baseHref;
    private TableProperties properties;
    private int pageNumber = 1;
    private int offset = 0;
    private MediaTypeEnum currentMediaType;
    private int previousSortedColumn;
    private boolean previousOrder;
    private boolean sortFullTable;
    private String requestUri;
    private boolean doAfterBodyExecuted;
    private String tableParameterIdentifier;
    private int defaultSortedColumn = -1;
    private String footer;
    static /* synthetic */ Class class$org$displaytag$tags$TableTag;
    static /* synthetic */ Class class$java$lang$String;

    public void setFooter(String string) {
        this.footer = string;
    }

    protected boolean isEmpty() {
        return this.currentRow == null;
    }

    public void setSort(String value) throws InvalidTagAttributeValueException {
        if ("page".equals(value)) {
            this.sortFullTable = false;
        } else if ("list".equals(value)) {
            this.sortFullTable = true;
        } else {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "sort", value);
        }
    }

    public void setRequestURI(String value) {
        this.requestUri = value;
    }

    public void setList(Object value) {
        this.list = value;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void setProperty(String value) {
        this.property = value;
    }

    public void setLength(String value) throws InvalidTagAttributeValueException {
        try {
            this.length = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "length", value);
        }
    }

    public void setDefaultsort(String value) throws InvalidTagAttributeValueException {
        try {
            this.defaultSortedColumn = Integer.parseInt(value) - 1;
        }
        catch (NumberFormatException e) {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "defaultsort", value);
        }
    }

    public void setPagesize(String value) throws InvalidTagAttributeValueException {
        try {
            this.pagesize = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "pagesize", value);
        }
    }

    public void setScope(String value) {
        this.scope = value;
    }

    public void setDecorator(String decorator) {
        this.decoratorName = decorator;
    }

    public void setExport(String booleanValue) {
        if (!Boolean.FALSE.toString().equals(booleanValue)) {
            this.export = true;
        }
    }

    public void setOffset(String value) throws InvalidTagAttributeValueException {
        try {
            int userOffset = Integer.parseInt(value);
            if (userOffset < 1) {
                throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "offset", value);
            }
            this.offset = userOffset - 1;
        }
        catch (NumberFormatException e) {
            throw new InvalidTagAttributeValueException(((Object)((Object)this)).getClass(), "offset", value);
        }
    }

    protected void setBaseHref(Href value) {
        this.baseHref = value;
    }

    public PageContext getPageContext() {
        return ((TagSupport)this).pageContext;
    }

    protected TableProperties getProperties() {
        return this.properties;
    }

    public void addColumn(HeaderCell column) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] addColumn " + column));
        }
        this.tableModel.addColumnHeader(column);
    }

    public void addCell(Cell cell) {
        if (this.currentRow != null) {
            this.currentRow.addCell(cell);
        }
    }

    protected boolean isFirstIteration() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] first iteration=" + (this.rowNumber == 1) + " (row number=" + this.rowNumber + ")"));
        }
        return this.rowNumber == 1;
    }

    public static void checkCommonsLang() throws JspTagException {
        if (commonsLangChecked) {
            return;
        }
        try {
            Class<?> stringUtils = Class.forName("org.apache.commons.lang.StringUtils");
            try {
                stringUtils.getMethod("capitalize", class$java$lang$String == null ? (class$java$lang$String = TableTag.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (NoSuchMethodException ee) {
                throw new JspTagException("\n\nYou appear to have an INCOMPATIBLE VERSION of the Commons Lang library.  \nDisplaytag requires version 2 of this library, and you appear to have a prior version in \nyour classpath.  You must remove this prior version AND ensure that ONLY version 2 is in \nyour classpath.\n If commons-lang-1.x is in your classpath, be sure to remove it. \nBe sure to delete all cached or temporary jar files from your application server; Tomcat \nusers should be sure to also check the CATALINA_HOME/shared folder; you may need to \nrestart the server. \ncommons-lang-2.jar is available in the displaytag distribution, or from the Jakarta \nwebsite at http://jakarta.apache.org/commons \n\n.");
            }
        }
        catch (ClassNotFoundException e) {
            throw new JspTagException("You do not appear to have the Commons Lang library, version 2.  commons-lang-2.jar is available in the displaytag distribution, or from the Jakarta website at http://jakarta.apache.org/commons .  ");
        }
        commonsLangChecked = true;
    }

    public int doStartTag() throws JspException {
        TableTag.checkCommonsLang();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doStartTag called"));
        }
        this.tableModel = new TableModel();
        this.tableModel.setId(this.getId());
        this.properties = new TableProperties();
        this.initParameters();
        if (this.currentMediaType != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] setting media [" + this.currentMediaType + "] in pagecontext"));
            }
            ((TagSupport)this).pageContext.setAttribute(PAGE_ATTRIBUTE_MEDIA, (Object)this.currentMediaType);
        }
        this.doIteration();
        return 2;
    }

    public int doAfterBody() throws JspException {
        this.doAfterBodyExecuted = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doAfterBody called - iterating on row " + this.rowNumber));
        }
        ++this.rowNumber;
        return this.doIteration();
    }

    protected int doIteration() throws JspException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doIteration called"));
        }
        if (this.currentRow != null) {
            this.tableModel.addRow(this.currentRow);
            this.currentRow = null;
        }
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            if (this.getId() != null) {
                if (iteratedObject != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("[" + this.getId() + "] setting attribute \"" + this.getId() + "\" in pagecontext"));
                    }
                    ((TagSupport)this).pageContext.setAttribute(this.getId(), iteratedObject);
                } else {
                    ((TagSupport)this).pageContext.removeAttribute(this.getId());
                }
                ((TagSupport)this).pageContext.setAttribute(((TagSupport)this).id + "_rowNum", (Object)new Integer(this.rowNumber));
            }
            this.currentRow = new Row(iteratedObject, this.rowNumber);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] doIteration() returning EVAL_BODY_TAG"));
            }
            return 2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doIteration() - iterator ended after " + (this.rowNumber - 1) + " rows"));
        }
        return 0;
    }

    private void initParameters() throws ObjectLookupException {
        this.initHref();
        RequestHelper requestHelper = new RequestHelper((HttpServletRequest)((TagSupport)this).pageContext.getRequest());
        Integer pageNumberParameter = requestHelper.getIntParameter(this.encodeParameter("p"));
        this.pageNumber = pageNumberParameter == null ? 1 : pageNumberParameter;
        Integer sortColumnParameter = requestHelper.getIntParameter(this.encodeParameter("s"));
        int sortColumn = sortColumnParameter == null ? this.defaultSortedColumn : sortColumnParameter;
        this.tableModel.setSortedColumnNumber(sortColumn);
        this.tableModel.setSortFullTable(this.sortFullTable);
        Integer paramOrder = requestHelper.getIntParameter(this.encodeParameter("o"));
        boolean order = !new Integer(1).equals(paramOrder);
        this.tableModel.setSortOrderAscending(order);
        if (this.sortFullTable && sortColumn != -1) {
            this.baseHref.addParameter(this.encodeParameter("xs"), sortColumn);
            this.baseHref.addParameter(this.encodeParameter("xo"), paramOrder);
            Integer previousSortColumnParameter = requestHelper.getIntParameter(this.encodeParameter("s"));
            this.previousSortedColumn = previousSortColumnParameter == null ? -1 : previousSortColumnParameter;
            Integer previousParamOrder = requestHelper.getIntParameter(this.encodeParameter("xo"));
            this.previousOrder = !new Integer(1).equals(previousParamOrder);
        }
        Integer exportTypeParameter = requestHelper.getIntParameter(this.encodeParameter("e"));
        this.currentMediaType = MediaTypeEnum.fromIntegerCode(exportTypeParameter);
        if (this.currentMediaType == null) {
            this.currentMediaType = MediaTypeEnum.HTML;
        }
        if (this.list == null) {
            StringBuffer fullName = new StringBuffer();
            if (this.scope != null && !"".equals(this.scope)) {
                fullName.append(this.scope).append("Scope.");
            }
            if (this.name != null) {
                fullName.append(this.name);
            }
            if (this.property != null && !"".equals(this.property)) {
                fullName.append('.').append(this.property);
            }
            this.list = this.evaluateExpression(fullName.toString());
        }
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
    }

    protected void initHref() {
        RequestHelper requestHelper = new RequestHelper((HttpServletRequest)((TagSupport)this).pageContext.getRequest());
        Href normalHref = requestHelper.getHref();
        if (this.requestUri != null) {
            this.baseHref = new Href(this.requestUri);
            HashMap parameterMap = normalHref.getParameterMap();
            this.baseHref.addParameterMap(parameterMap);
        } else {
            this.baseHref = normalHref;
        }
    }

    public int doEndTag() throws JspException {
        TableDecorator tableDecorator;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doEndTag called"));
        }
        if (!this.doAfterBodyExecuted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] tag body is empty. Iterates to preserve compatibility with previous version"));
            }
            if (this.currentRow != null) {
                this.tableModel.addRow(this.currentRow);
            }
            while (this.tableIterator.hasNext()) {
                Object iteratedObject = this.tableIterator.next();
                ++this.rowNumber;
                this.currentRow = new Row(iteratedObject, this.rowNumber);
                this.tableModel.addRow(this.currentRow);
            }
        }
        if (this.tableModel.isEmpty()) {
            this.describeEmptyTable();
        }
        if ((tableDecorator = DecoratorFactory.loadTableDecorator(this.decoratorName)) != null) {
            tableDecorator.init(((TagSupport)this).pageContext, this.list);
            this.tableModel.setTableDecorator(tableDecorator);
        }
        List pageData = this.getViewableData();
        this.tableModel.setRowListPage(pageData);
        if (!this.tableModel.isSortFullTable()) {
            this.tableModel.sortPageList();
        }
        StringBuffer buffer = new StringBuffer(8000);
        int returnValue = 6;
        if (MediaTypeEnum.HTML.equals(this.currentMediaType)) {
            buffer.append(this.getHTMLData());
            this.write(buffer);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] doEndTag - exporting"));
            }
            returnValue = this.doExport();
        }
        this.listHelper = null;
        this.export = false;
        this.currentMediaType = null;
        this.scope = null;
        this.property = null;
        this.decoratorName = null;
        this.pagesize = 0;
        this.length = 0;
        this.offset = 0;
        this.defaultSortedColumn = -1;
        this.rowNumber = 1;
        this.list = null;
        this.sortFullTable = false;
        this.doAfterBodyExecuted = false;
        this.currentRow = null;
        this.tableModel = null;
        this.requestUri = null;
        this.tableParameterIdentifier = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] doEndTag - end"));
        }
        return returnValue;
    }

    private void describeEmptyTable() {
        this.tableIterator = IteratorUtils.getIterator((Object)this.list);
        if (this.tableIterator.hasNext()) {
            Object iteratedObject = this.tableIterator.next();
            Map objectProperties = new HashMap();
            try {
                objectProperties = BeanUtils.describe(iteratedObject);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to automatically add columns: " + e.getMessage()), (Throwable)e);
            }
            Iterator propertiesIterator = objectProperties.keySet().iterator();
            while (propertiesIterator.hasNext()) {
                String propertyName = (String)propertiesIterator.next();
                if ("class".equals(propertyName)) continue;
                HeaderCell headerCell = new HeaderCell();
                headerCell.setBeanPropertyName(propertyName);
                this.tableModel.addColumnHeader(headerCell);
            }
        }
    }

    protected int doExport() throws JspException {
        BaseExportView exportView = null;
        boolean exportFullList = this.properties.getExportFullList();
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] currentMediaType=" + this.currentMediaType));
        }
        boolean exportHeader = this.properties.getExportHeader(this.currentMediaType);
        exportView = ExportViewFactory.getView(this.currentMediaType, this.tableModel, exportFullList, exportHeader);
        String mimeType = exportView.getMimeType();
        String exportString = exportView.doExport();
        return this.writeExport(mimeType, exportString);
    }

    protected int writeExport(String mimeType, String exportString) throws JspException {
        ServletResponse response = ((TagSupport)this).pageContext.getResponse();
        JspWriter out = ((TagSupport)this).pageContext.getOut();
        HttpServletRequest request = (HttpServletRequest)((TagSupport)this).pageContext.getRequest();
        StringBuffer bodyBuffer = (StringBuffer)request.getAttribute(ResponseOverrideFilter.CONTENT_OVERRIDE_BODY);
        if (bodyBuffer != null) {
            StringBuffer contentTypeOverride = (StringBuffer)request.getAttribute(ResponseOverrideFilter.CONTENT_OVERRIDE_TYPE);
            contentTypeOverride.append(mimeType);
            bodyBuffer.append(exportString);
        } else {
            try {
                out.clear();
                response.setContentType(mimeType);
                out.write(exportString);
                out.flush();
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                throw new JspException(ex.getMessage());
            }
        }
        return 5;
    }

    public List getViewableData() throws JspException {
        List fullList = new ArrayList();
        if (this.tableModel.isSortFullTable()) {
            this.tableModel.sortFullList();
        }
        List originalData = this.tableModel.getRowListFull();
        fullList = CollectionUtil.getListFromObject(originalData, this.offset, this.length);
        if (this.pagesize > 0) {
            this.listHelper = new SmartListHelper(fullList, this.pagesize, this.properties);
            this.listHelper.setCurrentPage(this.pageNumber);
            fullList = this.listHelper.getListForCurrentPage();
        }
        return fullList;
    }

    private String getHTMLData() throws JspException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] getHTMLData called for table [" + this.getId() + "]"));
        }
        StringBuffer buffer = new StringBuffer(8000);
        this.previousRow = new Hashtable(10);
        this.nextRow = new Hashtable(10);
        if (this.properties.getAddPagingBannerTop()) {
            buffer.append(this.getSearchResultAndNavigation());
        }
        buffer.append(this.getOpenTag());
        if (this.properties.getShowHeader()) {
            buffer.append(this.getTableHeader());
        }
        buffer.append("\n<tbody>");
        RowIterator rowIterator = this.tableModel.getRowIterator();
        while (rowIterator.hasNext()) {
            String endRow;
            String stringStartRow;
            Row row = rowIterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] rowIterator.next()=" + row));
            }
            if (this.tableModel.getTableDecorator() != null && (stringStartRow = this.tableModel.getTableDecorator().startRow()) != null) {
                buffer.append(stringStartRow);
            }
            buffer.append(row.getOpenTag());
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + this.getId() + "] creating ColumnIterator on " + this.tableModel.getHeaderCellList()));
            }
            ColumnIterator columnIterator = row.getColumnIterator(this.tableModel.getHeaderCellList());
            while (columnIterator.hasNext()) {
                String value;
                Column column = columnIterator.nextColumn();
                try {
                    buffer.append(column.getOpenTag());
                    value = column.getChoppedAndLinkedValue();
                }
                catch (Exception ex) {
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    throw new JspException(ex.getMessage());
                }
                if (column.getGroup() != -1) {
                    try {
                        buffer.append(this.groupColumns(value.toString(), column.getGroup()));
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                } else {
                    buffer.append((Object)value);
                }
                buffer.append(column.getCloseTag());
            }
            if (this.tableModel.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[" + this.getId() + "] table has no columns"));
                }
                buffer.append("\n<td>");
                buffer.append(row.getObject().toString());
                buffer.append("</td>");
            }
            buffer.append(row.getCloseTag());
            if (this.tableModel.getTableDecorator() == null || (endRow = this.tableModel.getTableDecorator().finishRow()) == null) continue;
            buffer.append(endRow);
        }
        if (this.tableModel.getRowListPage().size() == 0) {
            buffer.append("\t\t<tr class=\"even empty\">\n");
            buffer.append("<td colspan=\"" + (this.tableModel.getNumberOfColumns() + 1) + "\">" + this.properties.getEmptyListMessage() + "</td></tr>");
        }
        buffer.append("</tbody>");
        buffer.append("</tbody>");
        if (this.footer != null) {
            buffer.append("\n<tfooter>");
            buffer.append(this.footer);
            buffer.append("</tfooter>");
            this.footer = null;
        }
        buffer.append(this.getCloseTag());
        buffer.append(this.getTableFooter());
        if (this.tableModel.getTableDecorator() != null) {
            this.tableModel.getTableDecorator().finish();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] getHTMLData end"));
        }
        return buffer.toString();
    }

    private String getTableHeader() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] getTableHeader called"));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n<thead>");
        buffer.append("\n<tr>");
        if (this.tableModel.isEmpty()) {
            buffer.append("\n<th>");
            buffer.append(this.properties.getNoColumnMessage());
            buffer.append("</th>");
        }
        Iterator iterator = this.tableModel.getHeaderCellList().iterator();
        while (iterator.hasNext()) {
            HeaderCell headerCell = (HeaderCell)iterator.next();
            if (headerCell.isAlreadySorted()) {
                headerCell.addHeaderClass("sorted");
                headerCell.addHeaderClass("order" + (this.tableModel.isSortOrderAscending() ? 1 : 2));
            }
            buffer.append(headerCell.getHeaderOpenTag());
            String header = headerCell.getTitle();
            if (headerCell.getSortable()) {
                boolean nowOrderAscending;
                Href href = new Href(this.baseHref);
                href.addParameter(this.encodeParameter("s"), headerCell.getColumnNumber());
                if (headerCell.isAlreadySorted() && this.tableModel.isSortOrderAscending()) {
                    href.addParameter(this.encodeParameter("o"), 1);
                    nowOrderAscending = false;
                } else {
                    href.addParameter(this.encodeParameter("o"), 2);
                    nowOrderAscending = true;
                }
                if (this.tableModel.isSortFullTable() && (headerCell.getColumnNumber() != this.previousSortedColumn || nowOrderAscending ^ this.previousOrder)) {
                    href.addParameter(this.encodeParameter("p"), 1);
                }
                Anchor anchor = new Anchor(href, header);
                buffer.append(anchor.toString());
            } else {
                buffer.append(header);
            }
            buffer.append(headerCell.getHeaderCloseTag());
        }
        buffer.append("</tr>");
        buffer.append("</thead>");
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] getTableHeader end"));
        }
        return buffer.toString();
    }

    private String getTableFooter() {
        StringBuffer buffer = new StringBuffer(1000);
        if (this.properties.getAddPagingBannerBottom()) {
            buffer.append(this.getSearchResultAndNavigation());
        }
        if (this.export) {
            buffer.append(this.getExportLinks());
        }
        return buffer.toString();
    }

    private String getSearchResultAndNavigation() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getId() + "] starting getSearchResultAndNavigation"));
        }
        if (this.pagesize != 0 && this.listHelper != null) {
            Href navigationHref = new Href(this.baseHref);
            navigationHref.addParameter(this.encodeParameter("p"), "{0,number,#}");
            StringBuffer buffer = new StringBuffer().append(this.listHelper.getSearchResultsSummary()).append(this.listHelper.getPageNavigationBar(navigationHref.toString()));
            return buffer.toString();
        }
        return "";
    }

    private String getExportLinks() {
        Href exportHref = new Href(this.baseHref);
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = MediaTypeEnum.iterator();
        while (iterator.hasNext()) {
            MediaTypeEnum currentExportType = (MediaTypeEnum)iterator.next();
            if (!this.properties.getAddExport(currentExportType)) continue;
            if (buffer.length() > 0) {
                buffer.append(this.properties.getExportBannerSeparator());
            }
            exportHref.addParameter(this.encodeParameter("e"), currentExportType.getCode());
            Anchor anchor = new Anchor(exportHref, this.properties.getExportLabel(currentExportType));
            buffer.append(anchor.toString());
        }
        Object[] exportOptions = new String[]{buffer.toString()};
        return MessageFormat.format(this.properties.getExportBanner(), exportOptions);
    }

    private String groupColumns(String value, int group) {
        if (group == 1 & this.nextRow.size() > 0) {
            this.previousRow.clear();
            this.previousRow.putAll(this.nextRow);
            this.nextRow.clear();
        }
        if (!this.nextRow.containsKey(new Integer(group))) {
            this.nextRow.put(new Integer(group), new String(value));
        }
        if (this.previousRow.containsKey(new Integer(group))) {
            int j = 1;
            while (j <= group) {
                if (!((String)this.previousRow.get(new Integer(j))).equals((String)this.nextRow.get(new Integer(j)))) {
                    return value;
                }
                ++j;
            }
        }
        if (this.previousRow.size() == 0) {
            return value;
        }
        return "";
    }

    public void setProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
    }

    public void release() {
        super.release();
    }

    public String getName() {
        return this.name;
    }

    protected String encodeParameter(String parameterName) {
        if (this.tableParameterIdentifier == null) {
            String stringIdentifier = "x-" + this.getId() + this.name;
            char[] charArray = stringIdentifier.toCharArray();
            int checkSum = 0;
            int j = 0;
            while (j < charArray.length) {
                checkSum += charArray[j] * j;
                ++j;
            }
            this.tableParameterIdentifier = "d-" + checkSum + "-";
        }
        return this.tableParameterIdentifier + parameterName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

